/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolHelper {
    public static final ToolAction HAMMER_DIG = ToolAction.get((String)"hammer_dig");
    public static final ToolAction KATAR_DIG = ToolAction.get((String)"katar_dig");
    public static final ToolAction MORNING_STAR_DIG = ToolAction.get((String)"morning_star_dig");
    public static final Set<ToolAction> DEFAULT_PE_HAMMER_ACTIONS = ToolHelper.of(HAMMER_DIG);
    public static final Set<ToolAction> DEFAULT_PE_KATAR_ACTIONS = ToolHelper.of(KATAR_DIG);
    public static final Set<ToolAction> DEFAULT_PE_MORNING_STAR_ACTIONS = ToolHelper.of(MORNING_STAR_DIG);
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.m_5833_() && entity instanceof IForgeShearable;
    private static final Predicate<Entity> SLAY_MOB = entity -> !entity.m_5833_() && entity instanceof Enemy;
    private static final Predicate<Entity> SLAY_ALL = entity -> !entity.m_5833_() && (entity instanceof Enemy || entity instanceof LivingEntity);

    private static Set<ToolAction> of(ToolAction ... actions) {
        return Stream.of(actions).collect(Collectors.toCollection(Sets::newIdentityHashSet));
    }

    @SafeVarargs
    public static InteractionResult performActions(InteractionResult firstAction, Supplier<InteractionResult> ... secondaryActions) {
        if (firstAction == InteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        InteractionResult result = firstAction;
        boolean hasFailed = result == InteractionResult.FAIL;
        for (Supplier<InteractionResult> secondaryAction : secondaryActions) {
            result = secondaryAction.get();
            if (result == InteractionResult.SUCCESS) {
                return InteractionResult.SUCCESS;
            }
            hasFailed &= result == InteractionResult.FAIL;
        }
        if (hasFailed) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult clearTagAOE(Level level, Player player, InteractionHand hand, ItemStack stack, long emcCost, TagKey<Block> tag) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return InteractionResult.PASS;
        }
        int scaled1 = 5 * charge;
        int scaled2 = 10 * charge;
        BlockPos corner1 = player.m_142538_().m_142082_(-scaled1, -scaled2, -scaled1);
        BlockPos corner2 = player.m_142538_().m_142082_(scaled1, scaled2, scaled1);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(corner1, corner2)) {
            BlockState state = level.m_8055_(pos);
            if (!state.m_204336_(tag)) continue;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, pos = pos.m_7949_())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, pos), (Entity)player, (ItemStack)stack));
            level.m_7471_(pos, false);
            hasAction = true;
            if (level.f_46441_.nextInt(5) != 0) continue;
            ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, player.m_20185_(), player.m_20186_(), player.m_20189_());
            PlayerHelper.swingItem(player, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult dowseCampfire(UseOnContext context, BlockState state) {
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        if (state.m_60734_() instanceof CampfireBlock && ((Boolean)state.m_61143_((Property)CampfireBlock.f_51227_)).booleanValue()) {
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            if (!level.m_5776_()) {
                level.m_5898_(null, 1009, pos, 0);
            }
            CampfireBlock.m_152749_((Entity)player, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.FALSE), 11);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tillHoeAOE(UseOnContext context, long emcCost) {
        BlockPos pos;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.m_43725_();
        Block type = level.m_8055_(pos = context.m_8083_()).m_60734_();
        Pair conversion = (Pair)HoeItem.f_41332_.get(type);
        if (conversion == null) {
            return InteractionResult.PASS;
        }
        Predicate canConvert = (Predicate)conversion.getFirst();
        if (!canConvert.test(context)) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Consumer converter = (Consumer)conversion.getSecond();
        converter.accept(context);
        level.m_5594_(null, pos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
        ItemStack stack = context.m_43722_();
        int charge = ToolHelper.getCharge(stack);
        if (charge > 0) {
            for (BlockPos newPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-charge, 0, -charge), (BlockPos)pos.m_142082_(charge, 0, charge))) {
                if (pos.equals((Object)newPos) || !level.m_8055_(newPos).m_60713_(type)) continue;
                newPos = newPos.m_7949_();
                UseOnContext adjustedContext = new UseOnContext(level, player, context.m_43724_(), stack, new BlockHitResult(context.m_43720_().m_82520_((double)(newPos.m_123341_() - pos.m_123341_()), (double)(newPos.m_123342_() - pos.m_123342_()), (double)(newPos.m_123343_() - pos.m_123343_())), context.m_43719_(), newPos, context.m_43721_()));
                if (!canConvert.test(adjustedContext)) continue;
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                converter.accept(adjustedContext);
            }
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult flattenAOE(UseOnContext context, long emcCost) {
        BlockPos pos;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Direction sideHit = context.m_43719_();
        if (sideHit == Direction.DOWN) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockState tilledState = level.m_8055_(pos = context.m_8083_()).getToolModifiedState(level, pos, player, stack, ToolActions.SHOVEL_FLATTEN);
        if (tilledState == null) {
            return InteractionResult.PASS;
        }
        BlockPos abovePos = pos.m_7494_();
        BlockState aboveState = level.m_8055_(abovePos);
        if (aboveState.m_60804_((BlockGetter)level, abovePos)) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        level.m_7731_(pos, tilledState, 11);
        ToolHelper.removeAboveIfPlant((ServerPlayer)player, level, pos.m_7494_(), aboveState);
        level.m_5594_(null, pos, SoundEvents.f_12406_, SoundSource.BLOCKS, 1.0f, 1.0f);
        int charge = ToolHelper.getCharge(stack);
        if (charge > 0) {
            for (BlockPos newPos : BlockPos.m_121940_((BlockPos)pos.m_142082_(-charge, 0, -charge), (BlockPos)pos.m_142082_(charge, 0, charge))) {
                if (pos.equals((Object)newPos) || (aboveState = level.m_8055_(newPos.m_7494_())).m_60804_((BlockGetter)level, newPos.m_7494_()) || tilledState != level.m_8055_(newPos).getToolModifiedState(level, newPos, player, stack, ToolActions.SHOVEL_FLATTEN)) continue;
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                newPos = newPos.m_7949_();
                level.m_7731_(newPos, tilledState, 11);
                ToolHelper.removeAboveIfPlant((ServerPlayer)player, level, newPos.m_7494_(), aboveState);
            }
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private static void removeAboveIfPlant(ServerPlayer player, Level level, BlockPos above, BlockState aboveState) {
        Material aboveMaterial = aboveState.m_60767_();
        if ((aboveMaterial == Material.f_76300_ || aboveMaterial == Material.f_76302_) && !aboveState.m_155947_() && PlayerHelper.hasBreakPermission(player, above)) {
            level.m_46961_(above, true);
        }
    }

    public static InteractionResult stripLogsAOE(UseOnContext context, long emcCost) {
        return ToolHelper.useAxeAOE(context, emcCost, ToolActions.AXE_STRIP, SoundEvents.f_11688_, -1);
    }

    public static InteractionResult scrapeAOE(UseOnContext context, long emcCost) {
        return ToolHelper.useAxeAOE(context, emcCost, ToolActions.AXE_SCRAPE, SoundEvents.f_144059_, 3005);
    }

    public static InteractionResult waxOffAOE(UseOnContext context, long emcCost) {
        return ToolHelper.useAxeAOE(context, emcCost, ToolActions.AXE_WAX_OFF, SoundEvents.f_144060_, 3004);
    }

    public static InteractionResult useAxeAOE(UseOnContext context, long emcCost, ToolAction action, SoundEvent sound, int particle) {
        int charge;
        BlockPos pos;
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        Level level = context.m_43725_();
        BlockState clickedState = level.m_8055_(pos = context.m_8083_());
        BlockState strippedState = clickedState.getToolModifiedState(level, pos, player, stack, action);
        if (strippedState == null) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        Direction.Axis axis = ToolHelper.getAxis(clickedState);
        level.m_7731_(pos, strippedState, 11);
        level.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (particle != -1) {
            level.m_5898_(null, particle, pos, 0);
        }
        if ((charge = ToolHelper.getCharge(stack)) > 0) {
            Direction side = context.m_43719_();
            for (BlockPos newPos : WorldHelper.getPositionsFromBox(WorldHelper.getBroadBox(pos, side, charge))) {
                BlockState state;
                if (pos.equals((Object)newPos) || axis != ToolHelper.getAxis(state = level.m_8055_(newPos)) || strippedState != state.getToolModifiedState(level, newPos, player, stack, action)) continue;
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                newPos = newPos.m_7949_();
                level.m_7731_(newPos, strippedState, 11);
                if (particle == -1) continue;
                level.m_5898_(null, particle, newPos, 0);
            }
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Nullable
    private static Direction.Axis getAxis(BlockState state) {
        return state.m_61138_((Property)RotatedPillarBlock.f_55923_) ? (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_) : null;
    }

    public static void digBasedOnMode(ItemStack stack, Level level, BlockPos pos, LivingEntity living, RayTracePointer tracePointer) {
        BlockHitResult result;
        if (level.f_46443_ || ProjectEConfig.server.items.disableAllRadiusMining.get() || !(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        byte mode = ToolHelper.getMode(stack);
        if (mode == 0) {
            return;
        }
        HitResult mop = tracePointer.rayTrace(level, player, ClipContext.Fluid.NONE);
        if (!(mop instanceof BlockHitResult) || (result = (BlockHitResult)mop).m_6662_() == HitResult.Type.MISS || !pos.equals((Object)result.m_82425_())) {
            return;
        }
        Direction sideHit = result.m_82434_();
        AABB box = switch (mode) {
            case 1 -> new AABB(pos.m_7495_(), pos.m_7494_());
            case 2 -> {
                switch (sideHit.m_122434_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield new AABB(pos.m_142128_(), pos.m_142127_());
                    }
                    case Y: {
                        switch (player.m_6350_().m_122434_()) {
                            case X: {
                                yield new AABB(pos.m_142128_(), pos.m_142127_());
                            }
                            case Z: {
                                yield new AABB(pos.m_142125_(), pos.m_142126_());
                            }
                        }
                        yield new AABB(pos, pos);
                    }
                    case Z: 
                }
                yield new AABB(pos.m_142125_(), pos.m_142126_());
            }
            case 3 -> new AABB(pos, pos.m_5484_(sideHit.m_122424_(), 2));
            default -> new AABB(pos, pos);
        };
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state;
            if (level.m_46859_(digPos) || (state = level.m_8055_(digPos)).m_60800_((BlockGetter)level, digPos) == -1.0f || !stack.m_41735_(state) || !PlayerHelper.hasBreakPermission((ServerPlayer)player, digPos = digPos.m_7949_())) continue;
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)digPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, digPos), (Entity)player, (ItemStack)stack));
            level.m_7471_(digPos, false);
        }
        WorldHelper.createLootDrop(drops, level, pos);
    }

    public static InteractionResult digAOE(Level level, Player player, InteractionHand hand, ItemStack stack, BlockPos pos, Direction sideHit, boolean affectDepth, long emcCost) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        int charge = ToolHelper.getCharge(stack);
        if (charge == 0) {
            return InteractionResult.PASS;
        }
        AABB box = affectDepth ? WorldHelper.getBroadDeepBox(pos, sideHit, charge) : WorldHelper.getFlatYBox(pos, charge);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos newPos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state;
            if (level.m_46859_(newPos) || (state = level.m_8055_(newPos)).m_60800_((BlockGetter)level, newPos) == -1.0f || !stack.m_41735_(state)) continue;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (!PlayerHelper.hasBreakPermission((ServerPlayer)player, newPos = newPos.m_7949_())) continue;
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            drops.addAll(Block.m_49874_((BlockState)state, (ServerLevel)((ServerLevel)level), (BlockPos)newPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, newPos), (Entity)player, (ItemStack)stack));
            level.m_7471_(newPos, false);
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, pos);
            PlayerHelper.swingItem(player, hand);
            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void attackWithCharge(ItemStack stack, LivingEntity damaged, LivingEntity damager, float baseDmg) {
        Player player;
        block5: {
            block4: {
                if (!(damager instanceof Player)) break block4;
                player = (Player)damager;
                if (!damager.m_20193_().f_46443_) break block5;
            }
            return;
        }
        DamageSource dmg = DamageSource.m_19344_((Player)player);
        int charge = ToolHelper.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg.m_19380_();
            totalDmg += (float)charge;
        }
        damaged.m_6469_(dmg, totalDmg);
    }

    public static void attackAOE(ItemStack stack, Player player, boolean slayAll, float damage, long emcCost, InteractionHand hand) {
        Level level = player.m_20193_();
        if (level.f_46443_) {
            return;
        }
        int charge = ToolHelper.getCharge(stack);
        List toAttack = level.m_6249_((Entity)player, player.m_142469_().m_82400_((double)(2.5f * (float)charge)), slayAll ? SLAY_ALL : SLAY_MOB);
        DamageSource src = DamageSource.m_19344_((Player)player).m_19380_();
        boolean hasAction = false;
        for (Entity entity : toAttack) {
            if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
            entity.m_6469_(src, damage);
            hasAction = true;
        }
        if (hasAction) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.CHARGE.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            PlayerHelper.swingItem(player, hand);
        }
    }

    public static InteractionResult shearBlock(ItemStack stack, BlockPos pos, Player player) {
        List drops;
        IForgeShearable target;
        Level level = player.m_20193_();
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof IForgeShearable && (target = (IForgeShearable)block).isShearable(stack, level, pos) && (level.f_46443_ || PlayerHelper.hasBreakPermission((ServerPlayer)player, pos)) && !(drops = target.onSheared(player, stack, level, pos, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack))).isEmpty()) {
            if (!level.f_46443_) {
                WorldHelper.createLootDrop(new ArrayList<ItemStack>(drops), level, pos);
                player.m_6278_(Stats.f_12949_.m_12902_((Object)block), 1);
                level.m_142346_((Entity)player, GameEvent.f_157781_, pos);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult shearEntityAOE(Player player, InteractionHand hand, long emcCost) {
        Level level = player.m_20193_();
        ItemStack stack = player.m_21120_(hand);
        int fortune = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)stack);
        int offset = (int)Math.pow(2.0, 2 + ToolHelper.getCharge(stack));
        List list = level.m_6443_(Entity.class, player.m_142469_().m_82377_((double)offset, (double)offset / 2.0, (double)offset), SHEARABLE);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (Entity ent : list) {
            Mob mob;
            Entity e;
            BlockPos entityPosition;
            IForgeShearable target = (IForgeShearable)ent;
            if (target.isShearable(stack, level, entityPosition = ent.m_142538_())) {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (!ItemPE.consumeFuel(player, stack, emcCost, true)) break;
                List entDrops = target.onSheared(player, stack, level, entityPosition, fortune);
                ent.m_146852_(GameEvent.f_157781_, (Entity)player);
                if (!entDrops.isEmpty()) {
                    drops.addAll(entDrops);
                    drops.addAll(entDrops);
                }
                hasAction = true;
            }
            if (level.f_46443_ || !(Math.random() < 0.01) || (e = ent.m_6095_().m_20615_(level)) == null) continue;
            e.m_6034_(ent.m_20185_(), ent.m_20186_(), ent.m_20189_());
            if (e instanceof Mob) {
                mob = (Mob)e;
                mob.m_6518_((ServerLevelAccessor)((ServerLevel)level), level.m_6436_(entityPosition), MobSpawnType.EVENT, null, null);
            }
            if (e instanceof Sheep) {
                Sheep sheep = (Sheep)e;
                sheep.m_29855_(DyeColor.m_41053_((int)MathUtils.randomIntInRange(0, 15)));
            }
            if (e instanceof AgeableMob) {
                mob = (AgeableMob)e;
                mob.m_146762_(-24000);
            }
            level.m_7967_(e);
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, player.m_20185_(), player.m_20186_(), player.m_20189_());
            PlayerHelper.swingItem(player, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult tryVeinMine(Player player, ItemStack stack, BlockPos pos, Direction sideHit) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        Level level = player.m_20193_();
        BlockState target = level.m_8055_(pos);
        if (target.m_60800_((BlockGetter)level, pos) <= -1.0f || !stack.m_41735_(target)) {
            return InteractionResult.FAIL;
        }
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos newPos : WorldHelper.getPositionsFromBox(WorldHelper.getBroadDeepBox(pos, sideHit, ToolHelper.getCharge(stack)))) {
            if (level.m_46859_(newPos)) continue;
            BlockState state = level.m_8055_(newPos);
            if (target.m_60734_() != state.m_60734_()) continue;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (WorldHelper.harvestVein(level, player, stack, newPos.m_7949_(), state.m_60734_(), drops, 0) <= 0) continue;
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, pos);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.DESTRUCT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult mineOreVeinsInAOE(Player player, InteractionHand hand) {
        if (ProjectEConfig.server.items.disableAllRadiusMining.get()) {
            return InteractionResult.PASS;
        }
        Level level = player.m_20193_();
        ItemStack stack = player.m_21120_(hand);
        boolean hasAction = false;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(player.m_142469_().m_82400_((double)(ToolHelper.getCharge(stack) + 3)))) {
            BlockState state;
            if (level.m_46859_(pos) || !ItemHelper.isOre(state = level.m_8055_(pos)) || state.m_60800_((BlockGetter)level, pos) == -1.0f || !stack.m_41735_(state)) continue;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (WorldHelper.harvestVein(level, player, stack, pos.m_7949_(), state.m_60734_(), drops, 0) <= 0) continue;
            hasAction = true;
        }
        if (hasAction) {
            WorldHelper.createLootDrop(drops, level, player.m_20185_(), player.m_20186_(), player.m_20189_());
            PlayerHelper.swingItem(player, hand);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static float getDestroySpeed(float parentDestroySpeed, EnumMatterType matterType, int charge) {
        if (parentDestroySpeed == 1.0f) {
            return parentDestroySpeed;
        }
        return parentDestroySpeed + matterType.getChargeModifier() * (float)charge;
    }

    public static boolean canMatterMine(EnumMatterType matterType, Block block) {
        IMatterBlock matterBlock;
        return block instanceof IMatterBlock && (matterBlock = (IMatterBlock)block).getMatterType().getMatterTier() <= matterType.getMatterTier();
    }

    private static int getCharge(ItemStack stack) {
        return stack.getCapability(PECapabilities.CHARGE_ITEM_CAPABILITY).map(itemCharge -> itemCharge.getCharge(stack)).orElse(0);
    }

    private static byte getMode(ItemStack stack) {
        return stack.getCapability(PECapabilities.MODE_CHANGER_ITEM_CAPABILITY).map(itemMode -> itemMode.getMode(stack)).orElse((byte)0);
    }

    @FunctionalInterface
    public static interface RayTracePointer {
        public HitResult rayTrace(Level var1, Player var2, ClipContext.Fluid var3);
    }

    public static class ChargeAttributeCache {
        private static final UUID CHARGE_MODIFIER = UUID.fromString("69ADE509-46FF-3725-92AC-F59FB052BEC7");
        private final Int2ObjectMap<Multimap<Attribute, AttributeModifier>> cachedMaps = new Int2ObjectArrayMap();

        public Multimap<Attribute, AttributeModifier> addChargeAttributeModifier(Multimap<Attribute, AttributeModifier> currentModifiers, @NotNull EquipmentSlot slot, ItemStack stack) {
            int charge;
            if (slot == EquipmentSlot.MAINHAND && (charge = ToolHelper.getCharge(stack)) > 0) {
                return (Multimap)this.cachedMaps.computeIfAbsent(charge, c -> {
                    ImmutableMultimap.Builder attributesBuilder = ImmutableMultimap.builder();
                    attributesBuilder.putAll(currentModifiers);
                    attributesBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(CHARGE_MODIFIER, "Charge modifier", (double)c, AttributeModifier.Operation.ADDITION));
                    return attributesBuilder.build();
                });
            }
            return currentModifiers;
        }
    }
}

